{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:20:14 $                                        =}
{========================================================================}
unit Unit1;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ComCtrls, ExtCtrls, MMSystem, MMPCMSup, MMDesign, MMDSPObj, MMACMCvt,
  MMObj, MMWavOut, MMACMDlg, MMDIBCv, MMLevel, MMConect, MMHook, MMWavIn,
  MMWave;

type
  TMainForm = class(TForm)
    ACM: TMMACM;
    ACMConverter: TMMACMConverter;
    MMDesigner1: TMMDesigner;
    btnStart: TButton;
    btnStop: TButton;
    MMConnector1: TMMConnector;
    MMLevel1: TMMLevel;
    WaveIn: TMMWaveIn;
    WaveFile: TMMWaveFile;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   // close the device finally
   WaveIn.Close;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
begin
   if ACM.ChooseFormat(WaveIn.PWaveFormat,'Select Format') then
   begin
      // set here the destination format
      ACMConverter.PWaveFormat := ACM.PWaveFormat;

      // start recording
      WaveIn.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   // close the device
   WaveIn.Close;
end;

end.



